<?php
declare(strict_types=1);

// ── Load konfigurasi ──────────────────────────────────────────────────────────
require_once __DIR__ . '/config/env.php';
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/routes/router.php';

// ── CORS ──────────────────────────────────────────────────────────────────────
// Saat di Laragon, frontend React (Vite dev) jalan di port berbeda (5173)
// sehingga perlu CORS header
$allowedOrigin = env('FRONTEND_URL', 'http://localhost:5173');

header('Access-Control-Allow-Origin: ' . $allowedOrigin);
header('Access-Control-Allow-Methods: GET, POST, PUT, PATCH, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Access-Control-Allow-Credentials: true');

// Default response type JSON (controller file-serve akan override ini)
header('Content-Type: application/json; charset=UTF-8');

// ── Preflight OPTIONS ─────────────────────────────────────────────────────────
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

// ── Dispatch ──────────────────────────────────────────────────────────────────
$router = new Router();
require_once __DIR__ . '/routes/api.php';
$router->dispatch();
